/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.depsolver;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolverDefs;
import com.inprise.vbroker.compiler.backends.depsolver.DependencySpec;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import java.util.Hashtable;
import java.util.Vector;

public final class DepSolver
implements DepSolverDefs {
    private boolean Trace = false;
    public ErrorReporter _ER;
    private boolean Toplevel = false;
    private DependencySpec DepSpec;
    public ContainedNode[] _definitions;
    public int _numDefinitions;
    public int[] _codes;
    private Vector DepNodes = new Vector(100);
    public Hashtable IdlNode2DepNodeMap;
    private Vector NodesInCycle;
    private ModuleNode currentModule;
    private int currentModuleIndex;
    private Vector _v = new Vector();
    private ContainedNode[] _tmpDefinitions;
    private int[] _tmpCodes;
    private Hashtable modulesSeen = new Hashtable();

    public DepSolver(DependencySpec depSpec, ContainerNode rootContainer) {
        this(depSpec, rootContainer, new Hashtable(200), new Vector(), true);
        this.solveIt();
    }

    DepSolver(DependencySpec depSpec, ContainerNode rootContainer, Hashtable idlNode2DepNodeMap, Vector nodesInCycle, boolean topLevel) {
        int numNodes;
        this._ER = rootContainer.ER();
        this.DepSpec = depSpec;
        this.IdlNode2DepNodeMap = idlNode2DepNodeMap;
        this.NodesInCycle = nodesInCycle;
        this.Toplevel = topLevel;
        this.createDependencyNodes(rootContainer);
        switch (rootContainer.kind()) {
            case 6: {
                numNodes = ((ContainedContainerNode)rootContainer)._contents.size() * 2;
                break;
            }
            case 17: {
                numNodes = ((RepositoryNode)rootContainer).numObjects() * 2;
                break;
            }
            default: {
                numNodes = ((ContainedContainerNode)rootContainer)._contents.size();
            }
        }
        this._definitions = new ContainedNode[numNodes];
        this._codes = new int[numNodes];
    }

    private boolean breakable(int type) {
        return type == 6 ? this.DepSpec._modulesAreBreakable : false;
    }

    public boolean breakable(ContainerNode container) {
        return container.kind() == 6 ? this.DepSpec._modulesAreBreakable : false;
    }

    private boolean canForwardDeclare(DepNode source, int edgeNum) {
        Object o;
        DepNode target = (DepNode)source.DependsOnDecl.elementAt(edgeNum);
        ContainedNode idlDefn = target.IDLDefn;
        if (idlDefn._kind == 5) {
            if (!this.DepSpec._inheritablesCanBeForwardDeclared) {
                if (this.Trace) {
                    System.err.println(String.valueOf(target.name()).concat(" cannot be forward declared because *no* interfaces can be."));
                }
                return false;
            }
        } else if (idlDefn._kind == 20) {
            if (!this.DepSpec._inheritablesCanBeForwardDeclared) {
                if (this.Trace) {
                    System.err.println(String.valueOf(target.name()).concat(" cannot be forward declared because *no* values can be."));
                }
                return false;
            }
        } else {
            if (this.Trace) {
                System.err.println(String.valueOf(target.name()).concat(" cannot be forward declared because it is neither an interface nor a value."));
            }
            return false;
        }
        if ((o = this.IdlNode2DepNodeMap.get(idlDefn)) instanceof DepNode[]) {
            source.DependsOnDecl.setElementAt(((DepNode[])o)[0], edgeNum);
            if (this.Trace) {
                System.err.println(String.valueOf(new StringBuffer("Declaration for ").append(target.name()).append(" already exists; switching to it.")));
            }
            return true;
        }
        DepNode[] array = new DepNode[]{new DepNode(target.IDLDefn, false), target};
        ModuleNode module = this.moduleOf(target.IDLDefn);
        if (module != null) {
            array[0].addDependency(this.idlDefn2DepNode(module, true), true);
        }
        this.IdlNode2DepNodeMap.put(target.IDLDefn, array);
        source.DependsOnDecl.setElementAt(array[0], edgeNum);
        if (this.Trace) {
            System.err.println(String.valueOf(new StringBuffer("Creating declaration for ").append(target.name()).append(" and switching ").append(source.name()).append("'s edge to it.")));
        }
        return true;
    }

    private void cleanupSolutionTrace() {
        ContainedNode IDLDefn;
        int i;
        this._tmpDefinitions = new ContainedNode[this._numDefinitions * 4];
        this._tmpCodes = new int[this._numDefinitions * 4];
        for (i = 0; i < this._numDefinitions; ++i) {
            IDLDefn = this._definitions[i];
            ModuleNode nodesModule = this.moduleOf(IDLDefn);
            if (nodesModule != this.currentModule) {
                if (this.currentModule == null) {
                    this.openModule(nodesModule);
                } else if (nodesModule == null) {
                    this.closeModule(null);
                } else {
                    this.closeModule(nodesModule);
                    if (this.currentModule != nodesModule) {
                        this.openModule(nodesModule);
                    }
                }
            }
            if (this.currentModuleIndex == this._tmpDefinitions.length) {
                this.expandTmpArrays();
            }
            this._tmpDefinitions[this.currentModuleIndex] = this._definitions[i];
            this._tmpCodes[this.currentModuleIndex] = this._codes[i];
            ++this.currentModuleIndex;
        }
        if (this.currentModule != null) {
            this.closeModule(this.currentModule);
        }
        for (i = this.currentModuleIndex - 1; i >= 0; --i) {
            ModuleNode module;
            IDLDefn = this._tmpDefinitions[i];
            if (IDLDefn._kind != 6 || this.modulesSeen.get(module = (ModuleNode)IDLDefn) != Boolean.TRUE) continue;
            this.modulesSeen.put(module, Boolean.FALSE);
            this._tmpCodes[i] = 3;
        }
        this._numDefinitions = this.currentModuleIndex;
        this._definitions = new ContainedNode[this._numDefinitions];
        this._codes = new int[this._numDefinitions];
        System.arraycopy(this._tmpDefinitions, 0, this._definitions, 0, this._numDefinitions);
        System.arraycopy(this._tmpCodes, 0, this._codes, 0, this._numDefinitions);
        this._tmpDefinitions = null;
        this._tmpCodes = null;
    }

    private void cleanupSolutionTraceForUnbreakableModules() {
        int numModules = 0;
        for (int i = 0; i < this._numDefinitions; ++i) {
            if (this._definitions[i]._kind != 6) continue;
            ++numModules;
        }
        if (numModules == 0) {
            return;
        }
        int len = this._numDefinitions + numModules;
        this._tmpDefinitions = new ContainedNode[len];
        this._tmpCodes = new int[len];
        int index = 0;
        for (int i = 0; i < this._numDefinitions; ++i) {
            if (this._definitions[i]._kind == 6) {
                this._tmpDefinitions[index] = this._definitions[i];
                this._tmpCodes[index++] = 2;
                this._tmpDefinitions[index] = this._definitions[i];
                this._tmpCodes[index++] = 3;
                ((ContainerDepNode)this.idlDefn2DepNode((Node)this._definitions[i], (boolean)true)).Subgraph.cleanupSolutionTraceForUnbreakableModules();
                continue;
            }
            this._tmpDefinitions[index] = this._definitions[i];
            this._tmpCodes[index++] = this._codes[i];
        }
        this._definitions = this._tmpDefinitions;
        this._codes = this._tmpCodes;
        this._numDefinitions = this._tmpDefinitions.length;
    }

    private void closeModule(ModuleNode module) {
        ContainerNode lca = DepSolver.lca(this.currentModule, module);
        do {
            if (this.currentModuleIndex == this._tmpDefinitions.length) {
                this.expandTmpArrays();
            }
            this._tmpDefinitions[this.currentModuleIndex] = this.currentModule;
            this._tmpCodes[this.currentModuleIndex] = 5;
            ++this.currentModuleIndex;
            ContainerNode c = this.currentModule._container;
            if (!(c instanceof ModuleNode)) {
                this.currentModule = null;
                return;
            }
            this.currentModule = (ModuleNode)c;
        } while (this.currentModule != lca);
    }

    private void createDependencyEdges() {
        if (this.Trace) {
            System.err.println("createDependencyEdges invoked.");
        }
        int len = this.DepNodes.size();
        for (int i = 0; i < len; ++i) {
            DepNode node = (DepNode)this.DepNodes.elementAt(i);
            this.createEdgesFor(node);
            if (!(node instanceof ContainerDepNode)) continue;
            ((ContainerDepNode)node).Subgraph.createDependencyEdges();
        }
    }

    private void createDependencyNodes(ContainerNode rootContainer) {
        if (this.Trace) {
            System.err.println("createDependencyNodes invoked.");
        }
        Vector contents = rootContainer.contents();
        for (int i = 0; i < contents.size(); ++i) {
            DepNode depNode;
            boolean isContainer;
            Node node = (Node)contents.elementAt(i);
            int kind = node._kind;
            if (kind == 24) continue;
            if (kind == 23) {
                ContainedNode c = (ContainedNode)node;
                if (c._name.equals("TypeCode") || c._name.equals("Principal")) continue;
            }
            if ((isContainer = Node.isContainer(kind)) && !this.breakable(kind)) {
                depNode = new ContainerDepNode(this, (ContainerNode)contents.elementAt(i));
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating (unbreakable) container node for ").append(((ContainedNode)contents.elementAt((int)i))._name).append(".")));
                }
            } else {
                depNode = new DepNode((ContainedNode)contents.elementAt(i), true);
                if (isContainer) {
                    this.createDependencyNodes((ContainerNode)contents.elementAt(i));
                }
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating node for ").append(((ContainedNode)contents.elementAt((int)i))._name).append(".")));
                }
            }
            this.IdlNode2DepNodeMap.put(contents.elementAt(i), depNode);
            this.DepNodes.addElement(depNode);
        }
    }

    private void createEdgesFor(DepNode node) {
        int kind = node.IDLDefn._kind;
        switch (node.IDLDefn._kind) {
            case 6: 
            case 12: 
            case 23: {
                this.recordDependencyOnContainer(node);
                break;
            }
            case 3: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for constant ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                ConstantNode constant = (ConstantNode)node.IDLDefn;
                Type type = constant._type;
                this.recordTypeDependenciesFor(node, type, false);
                break;
            }
            case 4: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for exception ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Vector memberTypes = ((ExceptionNode)node.IDLDefn)._memberTypes;
                int len = memberTypes.size();
                for (int i = 0; i < len; ++i) {
                    Type memberType = (Type)memberTypes.elementAt(i);
                    this.recordTypeDependenciesFor(node, memberType, false);
                }
                break;
            }
            case 5: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for interface ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                InterfaceNode intrface = (InterfaceNode)node.IDLDefn;
                Vector bases = intrface._bases;
                for (int i = 0; i < bases.size(); ++i) {
                    InterfaceNode base = (InterfaceNode)bases.elementAt(i);
                    node.addDependency(this.idlDefn2DepNode(base, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
                }
                break;
            }
            case 20: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for value ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                ValueNode value = (ValueNode)node.IDLDefn;
                this.recordDependencyOnSuperValues(node);
                this.recordDependencyOnSuperInterfaces(node);
                Vector inits = value._initParamTypes;
                for (int i = 0; i < inits.size(); ++i) {
                    Vector paramType = (Vector)inits.elementAt(i);
                    for (int j = 0; j < paramType.size(); ++j) {
                        this.recordTypeDependenciesFor(node, (Type)paramType.elementAt(j), false);
                    }
                }
                break;
            }
            case 22: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for value member ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Type fieldType = ((ValueMemberNode)node.IDLDefn)._type;
                this.recordTypeDependenciesFor(node, fieldType, false);
                break;
            }
            case 10: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for struct ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Vector memberTypes = ((StructNode)node.IDLDefn)._memberTypes;
                int len = memberTypes.size();
                for (int i = 0; i < len; ++i) {
                    Type memberType = (Type)memberTypes.elementAt(i);
                    this.recordTypeDependenciesFor(node, memberType, false);
                }
                break;
            }
            case 7: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for operation ").append(node.name()).append(".")));
                }
                this.recordDependenciesForOperation(node);
                break;
            }
            case 9: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for alias ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Type origType = ((AliasNode)node.IDLDefn)._type;
                this.recordTypeDependenciesFor(node, origType, false);
                break;
            }
            case 21: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for value box ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Type boxedType = ((ValueBoxNode)node.IDLDefn)._type;
                this.recordTypeDependenciesFor(node, boxedType, false);
                break;
            }
            case 2: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for attribute ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Type type = ((AttributeNode)node.IDLDefn)._type;
                this.recordTypeDependenciesFor(node, type, false);
                break;
            }
            case 11: {
                if (this.Trace) {
                    System.err.println(String.valueOf(new StringBuffer("Creating edges for union ").append(node.name()).append(".")));
                }
                this.recordDependencyOnContainer(node);
                Type type = ((UnionNode)node.IDLDefn)._discriminator;
                if (!(type instanceof EnumNode) || ((EnumNode)type)._container != node.IDLDefn) {
                    this.recordTypeDependenciesFor(node, type, false);
                }
                Vector memberTypes = ((UnionNode)node.IDLDefn)._memberTypes;
                int len = memberTypes.size();
                for (int i = 0; i < len; ++i) {
                    Type memberType = (Type)memberTypes.elementAt(i);
                    this.recordTypeDependenciesFor(node, memberType, false);
                }
                break;
            }
            default: {
                this._ER.fatal("Comp.VerboseInternal", new Object[]{String.valueOf(new StringBuffer("unknown or invalid IDL type ").append(Node.typeName(kind)).append(" (").append(kind).append(")"))});
                break;
            }
        }
    }

    private static boolean definedWithin(ContainedNode defn, ContainerNode maybeAncestor) {
        ContainerNode c = defn._container;
        while (c != null && !(c instanceof RepositoryNode)) {
            if (c == maybeAncestor) {
                return true;
            }
            c = ((ContainedNode)((Object)c))._container;
        }
        return false;
    }

    private void expandTmpArrays() {
        ContainedNode[] newDefs = new ContainedNode[this._tmpDefinitions.length * 2];
        int[] newCodes = new int[this._tmpDefinitions.length * 2];
        System.arraycopy(this._tmpDefinitions, 0, newDefs, 0, this._tmpDefinitions.length);
        System.arraycopy(this._tmpCodes, 0, newCodes, 0, this._tmpDefinitions.length);
        this._tmpDefinitions = newDefs;
        this._tmpCodes = newCodes;
    }

    public DepNode idlDefn2DepNode(Node idlDefn, boolean defnReqd) {
        Object o = this.IdlNode2DepNodeMap.get(idlDefn);
        if (o == null) {
            return null;
        }
        if (o instanceof DepNode[]) {
            return ((DepNode[])o)[defnReqd ? 1 : 0];
        }
        return (DepNode)o;
    }

    private String indent(int indent) {
        String ret = "";
        for (int i = 0; i < indent; ++i) {
            ret = String.valueOf(ret).concat(" ");
        }
        return ret;
    }

    public boolean isForwardDeclared(InheritableNode node) {
        Object o = this.IdlNode2DepNodeMap.get(node);
        if (o == null) {
            this._ER.fatal("Comp.VerboseInternal", new Object[]{"no dependency node found for ".concat(String.valueOf(node._fullName))});
        }
        return o instanceof DepNode[];
    }

    private static ContainerNode lca(ModuleNode mod1, ModuleNode mod2) {
        if (mod1 == null || mod2 == null) {
            return null;
        }
        Vector<ModuleNode> scopes1 = new Vector<ModuleNode>(10);
        Vector<ModuleNode> scopes2 = new Vector<ModuleNode>(10);
        ContainerNode c = mod1;
        while (c != null) {
            scopes1.addElement((ModuleNode)c);
            if (c instanceof ModuleNode) {
                c = c._container;
                continue;
            }
            c = null;
        }
        c = mod2;
        while (c != null) {
            scopes2.addElement((ModuleNode)c);
            if (c instanceof ModuleNode) {
                c = c._container;
                continue;
            }
            c = null;
        }
        int index1 = scopes1.size() - 1;
        int lastValidIndex = index1;
        for (int index2 = scopes2.size() - 1; index1 >= 0 && index2 >= 0 && scopes1.elementAt(index1) == scopes2.elementAt(index2); --index2) {
            lastValidIndex = index1--;
        }
        return (ContainerNode)scopes1.elementAt(lastValidIndex);
    }

    private ModuleNode moduleOf(ContainedNode defn) {
        ContainerNode c = defn._container;
        while (c != null) {
            if (c instanceof ModuleNode) {
                return (ModuleNode)c;
            }
            if (c instanceof RepositoryNode) {
                return null;
            }
            c = ((ContainedNode)((Object)c))._container;
        }
        return null;
    }

    private void openModule(ModuleNode module) {
        this.openModule(module, DepSolver.lca(this.currentModule, module));
        this.currentModule = module;
    }

    private void openModule(ModuleNode module, ContainerNode lca) {
        if (module._container != module._repository && module._container != lca) {
            this.openModule((ModuleNode)module._container, lca);
        }
        if (this.currentModuleIndex == this._tmpDefinitions.length) {
            this.expandTmpArrays();
        }
        this._tmpDefinitions[this.currentModuleIndex] = module;
        this._tmpCodes[this.currentModuleIndex] = this.modulesSeen.get(module) == null ? 2 : 4;
        ++this.currentModuleIndex;
        this.modulesSeen.put(module, Boolean.TRUE);
    }

    private void printGraph(int indent) {
        int len = this.DepNodes.size();
        for (int i = 0; i < len; ++i) {
            int j;
            DepNode node = (DepNode)this.DepNodes.elementAt(i);
            System.err.print(String.valueOf(new StringBuffer(String.valueOf(this.indent(indent))).append("Dependency node ").append(node.name())));
            if (node instanceof ContainerDepNode) {
                System.err.println(String.valueOf(this.indent(indent)).concat(" (an unbreakable container):"));
            } else {
                System.err.println(String.valueOf(this.indent(indent)).concat(" (a normal node):"));
            }
            System.err.println(String.valueOf(new StringBuffer(String.valueOf(this.indent(indent))).append("IsDefn:").append(node.IsDefn)));
            if (node.DependsOnDefn.size() > 0) {
                System.err.println(String.valueOf(this.indent(indent)).concat("Definition Edges:"));
                for (j = 0; j < node.DependsOnDefn.size(); ++j) {
                    System.err.println(String.valueOf(new StringBuffer(String.valueOf(this.indent(indent))).append("  ").append(((DepNode)node.DependsOnDefn.elementAt(j)).name())));
                }
            } else {
                System.err.println(String.valueOf(this.indent(indent)).concat("Definition Edges: <none>"));
            }
            if (node.DependsOnDecl.size() > 0) {
                System.err.println(String.valueOf(this.indent(indent)).concat("Declaration Edges:"));
                for (j = 0; j < node.DependsOnDecl.size(); ++j) {
                    System.err.println(String.valueOf(new StringBuffer(String.valueOf(this.indent(indent))).append("  ").append(((DepNode)node.DependsOnDecl.elementAt(j)).name())));
                }
            } else {
                System.err.println(String.valueOf(this.indent(indent)).concat("Declaration Edges: <none>"));
            }
            if (node instanceof ContainerDepNode) {
                System.err.println(String.valueOf(this.indent(indent)).concat("SubDependency Graph:"));
                ((ContainerDepNode)node).Subgraph.printGraph(indent + 2);
            }
            System.err.println("\n");
        }
    }

    private void printSolution(String prefix, int len) {
        for (int i = 0; i < len; ++i) {
            System.err.print(String.valueOf(new StringBuffer("[").append(prefix).append(i).append("]\t ")));
            switch (this._codes[i]) {
                case 1: {
                    System.err.print("DECLARE ");
                    break;
                }
                case 6: {
                    System.err.print("DEFINE  ");
                    break;
                }
                case 2: {
                    System.err.print("BEGIN   ");
                    break;
                }
                case 3: {
                    System.err.print("END     ");
                    break;
                }
                case 4: {
                    System.err.print("OPEN    ");
                    break;
                }
                case 5: {
                    System.err.print("CLOSE   ");
                    break;
                }
                default: {
                    System.err.print("??????? ");
                }
            }
            ContainedNode node = this._definitions[i];
            if (node == null) {
                System.err.println(String.valueOf(new StringBuffer("ERROR!  node in position ").append(i).append(" was null; cannot print it.")));
                continue;
            }
            System.err.println(String.valueOf(new StringBuffer(String.valueOf(node.typeName())).append(" ").append(node._name)));
            if ((!node.isContainer() || this._codes[i] != 6) && (node._kind != 6 || this._codes[i] != 2 || this.DepSpec._modulesAreBreakable)) continue;
            ContainerDepNode cdep = (ContainerDepNode)this.idlDefn2DepNode(node, true);
            cdep.Subgraph.printSolution(String.valueOf(new StringBuffer(String.valueOf(prefix)).append(i).append(".")), cdep.Subgraph._numDefinitions);
        }
    }

    private void recordDependenciesForOperation(DepNode node) {
        this.recordDependencyOnContainer(node);
        OperationNode operation = (OperationNode)node.IDLDefn;
        Vector paramType = operation._paramTypes;
        Vector paramMode = operation._paramModes;
        for (int i = 0; i < paramType.size(); ++i) {
            if (paramMode.elementAt(i) == OperationNode.PARAM_IN) {
                this.recordTypeDependenciesFor(node, (Type)paramType.elementAt(i), false);
                continue;
            }
            if (paramMode.elementAt(i) == OperationNode.PARAM_OUT) {
                this.recordTypeDependenciesFor(node, (Type)paramType.elementAt(i), false);
                continue;
            }
            this.recordTypeDependenciesFor(node, (Type)paramType.elementAt(i), false);
        }
        this.recordTypeDependenciesFor(node, operation._result, false);
        Vector exception = operation._exceptions;
        for (int i = 0; i < exception.size(); ++i) {
            node.addDependency(this.idlDefn2DepNode((Node)exception.elementAt(i), true), true);
        }
    }

    private void recordDependencyOnContainer(DepNode node) {
        ContainerNode container;
        int kind;
        if (this.Trace) {
            ContainedNode n = node.IDLDefn;
            System.err.print(String.valueOf(new StringBuffer("recordDependencyOnContainer invoked for ").append(node.name()).append(" (container is ")));
            if (n._container == n._repository) {
                System.err.println("the repository)");
            } else {
                System.err.println(String.valueOf(((ContainedNode)((Object)n._container))._beName).concat(")."));
            }
        }
        if ((kind = (container = node.IDLDefn._container).kind()) != 17 && kind != 6) {
            node.addDependency(this.idlDefn2DepNode((Node)((Object)container), true), true);
        }
    }

    private void recordDependencyOnSuperInterfaces(DepNode node) {
        ValueNode value = (ValueNode)node.IDLDefn;
        InterfaceNode supports = value._supportedInterface;
        if (supports != null) {
            node.addDependency(this.idlDefn2DepNode(supports, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
        Vector abstractInterfaces = value._abstractInterfaces;
        for (int i = 0; i < abstractInterfaces.size(); ++i) {
            InterfaceNode absInterface = (InterfaceNode)abstractInterfaces.elementAt(i);
            node.addDependency(this.idlDefn2DepNode(absInterface, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
    }

    private void recordDependencyOnSuperValues(DepNode node) {
        ValueNode value = (ValueNode)node.IDLDefn;
        ValueNode baseValue = value._concreteBase;
        if (baseValue != null) {
            node.addDependency(this.idlDefn2DepNode(baseValue, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
        Vector abstractBaseValues = value._abstractBases;
        for (int i = 0; i < abstractBaseValues.size(); ++i) {
            ValueNode absBase = (ValueNode)abstractBaseValues.elementAt(i);
            node.addDependency(this.idlDefn2DepNode(absBase, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
    }

    private void recordTypeDependenciesFor(DepNode node, Type type, boolean defnReqd) {
        int kind = ((Node)((Object)type))._kind;
        switch (kind) {
            case 13: 
            case 14: 
            case 18: {
                return;
            }
            case 19: {
                return;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                ContainedNode c = (ContainedNode)((Object)type);
                if (this.Trace) {
                    System.err.println("Adding dependency edge to contained node ".concat(String.valueOf(c._fullName)));
                }
                node.addDependency(this.idlDefn2DepNode(c, defnReqd), defnReqd);
                return;
            }
            case 15: {
                SequenceNode seq = (SequenceNode)type;
                Type elemType = seq._type;
                if (elemType != node.IDLDefn) {
                    this.recordTypeDependenciesFor(node, elemType, defnReqd);
                }
                return;
            }
            case 16: {
                ArrayNode array = (ArrayNode)type;
                Type elemType = array._type;
                this.recordTypeDependenciesFor(node, elemType, defnReqd);
                return;
            }
        }
        this._ER.fatal("Comp.VerboseInternal", new Object[]{String.valueOf(new StringBuffer("unknown or invalid IDL type ").append(((Node)((Object)type)).typeName()).append(" (").append(kind).append(")"))});
    }

    private void recordVisit(DepNode node) {
        if (this.Trace) {
            System.err.println("Recording the visit to node ".concat(String.valueOf(node.name())));
        }
        if (this.DepSpec._modulesAreBreakable && node.IDLDefn._kind == 6 || (node.IDLDefn._kind == 7 || node.IDLDefn._kind == 2) && !this.DepSpec._showMethods) {
            return;
        }
        this._definitions[this._numDefinitions] = node.IDLDefn;
        this._codes[this._numDefinitions] = node.IsDefn ? 6 : 1;
        ++this._numDefinitions;
    }

    public boolean solveIt() {
        if (this.Trace) {
            System.err.println(String.valueOf(this.Toplevel ? "[toplevel]" : "").concat("solveIt invoked."));
        }
        if (this.Toplevel) {
            this.createDependencyEdges();
        }
        if (this.Trace && this.Toplevel) {
            System.err.println("\n----------Dependency Graph:---------------");
            this.printGraph(0);
            System.err.println("------------------------------------------\n");
        }
        int len = this.DepNodes.size();
        for (int i = 0; i < len; ++i) {
            DepNode node = (DepNode)this.DepNodes.elementAt(i);
            if (node.Visited || this.visit(node)) continue;
            this._ER.fatal("Comp.VerboseInternal", new Object[]{"circularity detected in dependency graph involving ".concat(String.valueOf(node.IDLDefn._fullName))});
        }
        if (this.Trace && this.Toplevel) {
            System.err.println("SOLUTION BEFORE CLEANUP:");
            this.printSolution("", this._numDefinitions);
            System.err.println("\n");
        }
        if (this.Toplevel) {
            if (this.DepSpec._modulesAreBreakable) {
                this.cleanupSolutionTrace();
            } else {
                this.cleanupSolutionTraceForUnbreakableModules();
            }
        }
        if (this.Trace && this.Toplevel) {
            System.err.println("SOLUTION AFTER CLEANUP:");
            this.printSolution("", this._definitions.length);
            System.err.println("\n");
        }
        return true;
    }

    private boolean visit(DepNode node) {
        DepNode target;
        int i;
        if (node.Visited) {
            this._ER.fatal("Comp.VerboseInternal", new Object[]{String.valueOf(new StringBuffer("node ").append(node.IDLDefn._name).append(" visited twice"))});
        }
        node.Visited = true;
        node.OnStack = true;
        if (this.Trace) {
            System.err.println(String.valueOf(new StringBuffer("Visiting ").append(node.IsDefn ? "definition" : "declaration").append(" of ").append(node.IDLDefn._name)));
        }
        int len = node.DependsOnDefn.size();
        for (i = 0; i < len; ++i) {
            target = (DepNode)node.DependsOnDefn.elementAt(i);
            if (this.Trace) {
                System.err.println(String.valueOf(new StringBuffer("Checking definition edge from ").append(node.IDLDefn._name).append(" to ").append(target.IDLDefn._name)));
            }
            if (target.OnStack) {
                if (this.Trace) {
                    System.err.println("...circularity detected; failing");
                }
                node.OnStack = false;
                node.Visited = false;
                return false;
            }
            if (!target.Visited && !this.visit(target)) {
                if (this.Trace) {
                    System.err.println("...circularity detected; failing");
                }
                node.OnStack = false;
                node.Visited = false;
                return false;
            }
            if (!this.Trace) continue;
            System.err.println(String.valueOf(new StringBuffer("(resume checks for ").append(node.IDLDefn._name).append(")")));
        }
        len = node.DependsOnDecl.size();
        for (i = 0; i < len; ++i) {
            target = (DepNode)node.DependsOnDecl.elementAt(i);
            if (this.Trace) {
                System.err.println(String.valueOf(new StringBuffer("Checking declaration edge from ").append(node.IDLDefn._name).append(" to ").append(target.IDLDefn._name)));
            }
            if (target.OnStack) {
                if (this.canForwardDeclare(node, i)) {
                    target = (DepNode)node.DependsOnDecl.elementAt(i);
                } else {
                    if (this.Trace) {
                        System.err.println("...circularity detected; failing");
                    }
                    node.OnStack = false;
                    node.Visited = false;
                    return false;
                }
            }
            if (!target.Visited && !this.visit(target)) {
                if (this.canForwardDeclare(node, i)) {
                    target = (DepNode)node.DependsOnDecl.elementAt(i);
                    if (this.Trace) {
                        System.err.println(String.valueOf(new StringBuffer("Re-trying visit of ").append(target.name()).append(" after (presumably) creating-or-switching-to its declaration")));
                    }
                    if (!target.Visited && !this.visit(target)) {
                        if (this.Trace) {
                            System.err.println("...circularity detected (the forward declaration didn't help!); failing");
                        }
                        node.OnStack = false;
                        node.Visited = false;
                        return false;
                    }
                } else {
                    if (this.Trace) {
                        System.err.println("...circularity detected; failing");
                    }
                    node.OnStack = false;
                    node.Visited = false;
                    return false;
                }
            }
            if (!this.Trace) continue;
            System.err.println(String.valueOf(new StringBuffer("(resume checks for ").append(node.IDLDefn._name).append(")")));
        }
        this.recordVisit(node);
        node.OnStack = false;
        if (node instanceof ContainerDepNode) {
            if (this.Trace) {
                System.err.println("This node is also a container; recursively solving that now.");
            }
            ((ContainerDepNode)node).Subgraph.solveIt();
        }
        if (this.Trace) {
            System.err.println("Leaving node ".concat(String.valueOf(node.IDLDefn._name)));
        }
        return true;
    }

    public class ContainerDepNode
    extends DepNode {
        public DepSolver Subgraph;

        ContainerDepNode(DepSolver this$0, ContainerNode container) {
            super((ContainedNode)((Object)container), true);
            this.Subgraph = new DepSolver(this$0.DepSpec, container, this$0.IdlNode2DepNodeMap, this$0.NodesInCycle, false);
        }
    }

    public class DepNode {
        public final ContainedNode IDLDefn;
        final boolean IsDefn;
        boolean Visited = false;
        boolean OnStack = false;
        public Vector DependsOnDefn = new Vector();
        public Vector DependsOnDecl = new Vector();
        public Vector GlobalDeps;

        public DepNode(ContainedNode defn, boolean isDefn) {
            this.IDLDefn = defn;
            this.IsDefn = isDefn;
        }

        String name() {
            return this.IDLDefn._name;
        }

        void addDependency(DepNode depNode, boolean requireDefn) {
            DepNode toProxyDepNode;
            if (DepSolver.this.Trace) {
                System.err.println(String.valueOf(new StringBuffer("Requesting dependency edge from IDLDefn ").append(this.IDLDefn._name).append(" to ").append(depNode.name()).append(".")));
            }
            ContainerNode myContainer = this.IDLDefn._container;
            ContainerNode hisContainer = depNode.IDLDefn._container;
            RepositoryNode repository = this.IDLDefn._repository;
            if (myContainer != repository && hisContainer == repository) {
                if (this.GlobalDeps == null) {
                    this.GlobalDeps = new Vector(5);
                }
                this.GlobalDeps.addElement(depNode.IDLDefn);
                if (DepSolver.this.Trace) {
                    System.err.println("(registering this edge as a `global target' dependency)");
                }
            }
            if (myContainer == hisContainer || myContainer == depNode.IDLDefn) {
                if (requireDefn) {
                    this.DependsOnDefn.addElement(depNode);
                } else {
                    this.DependsOnDecl.addElement(depNode);
                }
                return;
            }
            if (DepSolver.this.Trace) {
                System.err.println("Target was not my own container, nor did it share my container.");
                System.err.println("Begin searching for the LCA, in order to compute the proxy node(s) for this edge.");
            }
            DepSolver.this._v.setSize(0);
            ContainerNode c = myContainer;
            while (c != repository) {
                DepSolver.this._v.addElement(c);
                c = ((ContainedNode)((Object)c))._container;
            }
            int len = DepSolver.this._v.size();
            ContainerNode LCA = repository;
            c = hisContainer;
            block1: while (c != repository) {
                for (int i = 0; i < len; ++i) {
                    ContainerNode d = (ContainerNode)DepSolver.this._v.elementAt(i);
                    if (d != c) continue;
                    LCA = d;
                    break block1;
                }
                c = ((ContainedNode)((Object)c))._container;
            }
            ContainedNode fromProxy = this.IDLDefn;
            c = myContainer;
            while (c != repository && c != LCA && !DepSolver.this.breakable(c)) {
                fromProxy = (ContainedNode)((Object)c);
                c = ((ContainedNode)((Object)c))._container;
            }
            ContainedNode toProxy = depNode.IDLDefn;
            c = hisContainer;
            while (c != repository && c != LCA && !DepSolver.this.breakable(c)) {
                toProxy = (ContainedNode)((Object)c);
                c = ((ContainedNode)((Object)c))._container;
            }
            if (DepSolver.this.Trace) {
                if (fromProxy != this.IDLDefn) {
                    System.err.println("Assigning \"from\" proxy of ".concat(String.valueOf(fromProxy._name)));
                }
                if (toProxy != depNode.IDLDefn) {
                    System.err.println("Assigning \"to\"   proxy of ".concat(String.valueOf(toProxy._name)));
                }
            }
            DepNode fromProxyDepNode = fromProxy == this.IDLDefn ? this : DepSolver.this.idlDefn2DepNode(fromProxy, true);
            DepNode depNode2 = toProxyDepNode = toProxy == depNode.IDLDefn ? depNode : DepSolver.this.idlDefn2DepNode(toProxy, true);
            if (fromProxy == toProxy) {
                if (DepSolver.this.Trace) {
                    System.err.println("Dropping this dependency edge: would be circular");
                }
                return;
            }
            if (requireDefn || toProxy != depNode.IDLDefn) {
                fromProxyDepNode.DependsOnDefn.addElement(toProxyDepNode);
            } else {
                fromProxyDepNode.DependsOnDecl.addElement(toProxyDepNode);
            }
        }
    }
}

